<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Lesson extends Model
{
    protected $table = 'lessons';
    protected $primaryKey = 'Lesson_id';
    public $timestamps = true;

    protected $fillable = [
        'Section_id',
        'Type',
        'Title',
        'Content_url',
        'Video_link',
        'Duration',
        'Order',
        'Metadata',
        'Has_assignments',
        'Has_practice_tests',
        'Has_mock_interviews',
        'Has_interactive_elements',
    ];

    protected $casts = [
        'Created_at' => 'datetime',
        'Updated_at' => 'datetime',
        'Type' => 'string',
        'Duration' => 'integer',
        'Order' => 'integer',
        'Metadata' => 'array',
        'Has_assignments' => 'boolean',
        'Has_practice_tests' => 'boolean',
        'Has_mock_interviews' => 'boolean',
        'Has_interactive_elements' => 'boolean',
    ];

    public function section()
    {
        return $this->belongsTo(Section::class, 'Section_id', 'Section_id');
    }

    public function examQuestions()
    {
        return $this->hasMany(ExamQuestion::class, 'Lesson_id', 'Lesson_id');
    }

    public function videoProgress(): HasMany
    {
        return $this->hasMany(VideoProgress::class, 'Lesson_id', 'Lesson_id');
    }
}
